/* Copyright (c) 2003, Oracle Corporation.  All rights reserved.  */

/*

   NAME
     XPointer.c - XPointer demo

   DESCRIPTION
     Demonstrates how to use XPointer functionality

   MODIFIED   (MM/DD/YY)
   dlenkov     12/11/03 - dlenkov_test3 
   dlenkov     12/11/03 - 
   dlenkov     12/04/03 - Creation

*/

#include <stdio.h>

#ifndef XML_ORACLE
# include <xml.h>
#endif

#define DOCUMENT "pantry.xml"
#define XPATH "/child::pantry/child::*"

int main()
{
    xmlctx*     xctx;
    xmldocnode* doc;
    xmlnode*    nodep;
    xmlxptrloc* loc;
    xmlxptrlocset* locset;
    xmlerr      ecode;
    oratext*    str;
    int         i;
    int         n;

    puts( "XPointer sample");
 
    puts( "Initializing XML package...");
 
    if (!(xctx = XmlCreate(&ecode, (oratext *) "xpointer_xctx", NULL)))
    {
	printf( "Failed to create XML context, error %u\n", (unsigned) ecode);
	return 1;
    }

    printf( "Parsing '%s' ...\n", DOCUMENT);
    if (!(doc = XmlLoadDom(xctx, &ecode, "file", DOCUMENT, "validate", TRUE,
			   "discard_whitespace", TRUE, NULL)))
    {
	printf( "Parse failed, error %u\n", (unsigned) ecode);
	return 1;
    }

    if (!(locset = XmlXPointerEval( doc, (oratext*)XPATH)))
    {
      printf( "\nXPointer evaluation failed: no locset\n");
      return 1;
    }

    if (!(n = XmlXPtrLocSetGetLength( locset)))
    {
      printf( "\nXPointer evaluation failed: locset is empty\n");
      return 1;
    }

    for (i = 1; i <= n; i++)
    {
      loc = XmlXPtrLocSetGetItem( locset, i);
      str = XmlXPtrLocToString( loc);
      printf( "Location : %s\n", str); 
    }

    XmlFreeDocument( xctx, doc);
    XmlDestroy( xctx);

    return (uword)0;
}

/* end of file XPointer.c */

